# 画面設計書 52-フォームレイアウト（Foundation 6）

## 概要

本ドキュメントは、Symfony 8.1のTwig Bridgeが提供するFoundation 6対応フォームレイアウトテーマ（`foundation_6_layout.html.twig`）の画面設計書である。このテンプレートは、ZURB Foundation 6 CSSフレームワークに準拠したフォーム要素のレンダリングルールを定義するTwigテーマファイルであり、Foundation 5テーマと比較して大幅に簡素化されたブロックオーバーライドを持つ。

### 本画面の処理概要

**業務上の目的・背景**：Foundation 6 CSSフレームワークを採用するWebアプリケーションにおいて、Symfonyフォームの出力HTMLをFoundation 6のコンポーネントクラスに準拠させるためのテーマファイルである。Foundation 6ではFoundation 5から多くのCSS設計が変更され、フォーム要素のマークアップも簡素化された。本テーマはこの変更に対応し、Foundation 6のinput-group、switch-input等のコンポーネントを適切にレンダリングする。Foundation 5テーマ（51行以上）と比較して本テーマは51行と非常にコンパクトであり、Foundation 6がdiv_layoutとの互換性を高めた結果、少数のブロックのみオーバーライドすれば良い設計となっている。

**画面へのアクセス方法**：本テンプレートは直接URLでアクセスする画面ではなく、Symfonyの設定ファイル（`twig.yaml`）で`form_themes`として登録することで、フォームレンダリング時に自動的に適用される。設定例：`twig: form_themes: ['foundation_6_layout.html.twig']`

**主要な操作・処理内容**：
1. チェックボックス行のSwitch Input対応 - Foundation 6のSwitch Inputコンポーネント（`switch-input`クラス）に対応したチェックボックスのレンダリング。`switch-input`クラスが指定された場合、ラベル・チェックボックス・`switch-paddle`ラベルを順番にレンダリングする
2. 通貨入力のInput Group対応 - Foundation 6の`input-group`コンポーネントを使用して、通貨記号（`input-group-label`）と入力フィールド（`input-group-field`）を横並びにレイアウトする
3. パーセント入力のInput Group対応 - Foundation 6の`input-group`コンポーネントを使用して、パーセント記号と入力フィールドを横並びにレイアウトする
4. ボタンのFoundation 6クラス付与 - ボタン要素に`button`クラスを付与してFoundation 6のボタンスタイルを適用する

**画面遷移**：本テンプレートは画面遷移を持たない。フォームテーマとしてSymfonyフォームのレンダリング時に使用される共通テンプレートである。

**権限による表示制御**：本テーマファイル自体には権限制御はない。権限による表示制御はフォームを使用する個別画面のロジックで行われる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | Form | 主機能 | Foundation 6対応のフォームレイアウトテーマによるフォームレンダリング |
| 36 | Twig Bridge | 主機能 | Twig Bridgeのフォームレンダリング拡張によるFoundation 6用ブロック定義 |

## 画面種別

テンプレートテーマ（フォームレンダリング用共通テーマファイル）

## URL/ルーティング

本テンプレートは直接URLでアクセスされるものではない。`twig.yaml`の`form_themes`設定により、フォームレンダリング時に自動的に適用される。

## 入出力項目

本テーマはTwigブロックのオーバーライドにより各フォームタイプのレンダリングをカスタマイズする。以下はオーバーライドされるブロックと対応するフォームタイプの一覧である。

| ブロック名 | 対応フォームタイプ | 入力変数 | 出力HTML |
|-----------|-------------------|---------|---------|
| checkbox_row | CheckboxType | `parent_class`, `attr` | Switch Input対応のチェックボックス行、または通常のフォーム行 |
| money_widget | MoneyType | `money_pattern` | `input-group`によるプレフィックス/ポストフィックス付き通貨入力 |
| percent_widget | PercentType | `symbol` | `input-group`によるポストフィックス付きパーセント入力 |
| button_widget | ButtonType | `attr` | `button`クラスを付与した`<button>` |

## 表示項目

フォームテーマとして、以下のFoundation 6固有のUI要素を出力する。

| 表示要素 | CSSクラス | 説明 |
|---------|----------|------|
| Switch Input | `switch-input`, `switch-paddle` | Foundation 6のスイッチトグルコンポーネント |
| Input Group | `input-group`, `input-group-label`, `input-group-field` | 通貨・パーセント入力のグループ化 |
| ボタン | `button` | Foundation 6標準ボタンスタイル |

## イベント仕様

### 1-チェックボックスのSwitch Input切替

`attr.class`または`parent_class`に`switch-input`が含まれる場合、通常のチェックボックスレイアウトの代わりにFoundation 6のSwitch Inputコンポーネントとしてレンダリングされる。Switch Input表示では、ラベル、`switch-input`クラス付きのチェックボックス、`switch-paddle`クラス付きのラベルが順番に出力される。

### 2-通貨記号の位置判定

`money_pattern`変数の先頭が`{{`で始まるかどうかで、通貨記号のプレフィックス/ポストフィックス表示を判定する。先頭が`{{`で始まらない場合はプレフィックス、末尾が`}}`で終わらない場合はポストフィックスとして表示される。

## データベース更新仕様

### 操作別データベース影響一覧

本テーマファイルはフォームのHTML表示のみを担当し、データベース操作は行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

| メッセージ種別 | 表示条件 | 表示形式 | 内容 |
|---------------|---------|---------|------|
| バリデーションエラー | `errors|length > 0` | 親テーマ（form_div_layout）のエラー表示形式 | バリデーションエラーメッセージ |

本テーマではエラー表示ブロックをオーバーライドしていないため、親テーマ（`form_div_layout.html.twig`）のエラー表示がそのまま使用される。

## 例外処理

本テーマファイルはレンダリングのみを行うため、例外処理は含まない。テーマの読み込みに失敗した場合は、Twigのテンプレートローダーが例外をスローする。

## 備考

- 本テーマは`form_div_layout.html.twig`を継承（`{% extends 'form_div_layout.html.twig' %}`）しており、オーバーライドしないブロックは親テーマの定義がそのまま使用される
- Foundation 5テーマ（346行）と比較して大幅に簡素化（51行）されており、Foundation 6のCSS設計がdiv_layoutとの互換性を高めた結果である
- Switch Input機能はFoundation 6で導入されたコンポーネントであり、Foundation 5テーマには存在しない
- `money_widget`の判定ロジックがFoundation 5テーマとは異なり、`starts with`/`ends with`演算子を使用した判定に変更されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Symfonyフォームのレンダリングにおけるテーマの仕組みとTwigブロックの継承関係を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | 親テーマ。checkbox_row、money_widget、percent_widget、button_widgetのデフォルト実装を確認する |

**読解のコツ**: Foundation 6テーマはオーバーライドするブロックが少ないため、親テーマの各ブロック定義を確認することが重要である。特に`checkbox_row`（親テーマでは`form_row`ブロック経由）の処理フローを理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | foundation_6_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/foundation_6_layout.html.twig` | 本テーマファイル。4つのブロックのみオーバーライドしている |

**主要処理フロー**:
1. **行1**: `{% extends 'form_div_layout.html.twig' %}` - 親テーマの継承宣言
2. **行3-14**: `checkbox_row` - `switch-input`クラスの有無でSwitch Input表示と通常表示を切替
3. **行5**: `{% if 'switch-input' in parent_class %}` - Switch Input判定
4. **行7**: `{% set attr = attr|merge({class: ... 'switch-input'}) %}` - switch-inputクラスの付与
5. **行9**: `<label class="switch-paddle" for="{{ form.vars.id }}">` - パドルラベルの生成
6. **行16-33**: `money_widget` - `starts with`/`ends with`による通貨記号位置判定とinput-groupレイアウト
7. **行35-45**: `percent_widget` - symbol有無によるinput-groupレイアウト
8. **行47-50**: `button_widget` - buttonクラスの付与

#### Step 3: Foundation 5テーマとの比較

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | foundation_5_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/foundation_5_layout.html.twig` | Foundation 5テーマとの差分を理解する。346行 vs 51行の違い |

### プログラム呼び出し階層図

```
Twigテンプレート（form_widget(form) 呼び出し）
    |
    +-- FormExtension（Twig関数の解決）
    |       |
    |       +-- TwigRendererEngine（テーマブロックの解決）
    |               |
    |               +-- foundation_6_layout.html.twig（本テーマ - 4ブロック）
    |               |       |
    |               |       +-- checkbox_row（Switch Input対応）
    |               |       +-- money_widget（input-group対応）
    |               |       +-- percent_widget（input-group対応）
    |               |       +-- button_widget（buttonクラス）
    |               |
    |               +-- form_div_layout.html.twig（親テーマ - 未オーバーライドブロック）
    |
    +-- FormRenderer（レンダリング実行）
```

### データフロー図

```
[入力]                        [処理]                              [出力]

FormView                      foundation_6_layout.html.twig       Foundation 6
(フォームデータ、            ├── checkbox_row                    CSSクラス付き
 フォーム設定、              ├── money_widget                    HTML要素
 attr.class)                 ├── percent_widget                   ├── <div class="switch">
        |                     └── button_widget                    ├── <div class="input-group">
        +---> Twig Engine -->                                      └── <button class="button">
                              form_div_layout.html.twig
                              └── その他全ブロック（親テーマ）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| foundation_6_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/foundation_6_layout.html.twig` | テンプレート | Foundation 6フォームテーマ本体（51行） |
| form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | テンプレート | 親テーマ。div要素ベースの標準フォームレイアウト（482行） |
| foundation_5_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/foundation_5_layout.html.twig` | テンプレート | Foundation 5テーマ。比較参照用（346行） |
| FormExtension.php | `src/Symfony/Bridge/Twig/Extension/FormExtension.php` | ソース | Twigフォームレンダリング関数の登録 |
